//
//  ViewController.swift
//  CollectionViewAnimationsDemo
//
//  Created by Jake Marsh on 4/3/17.
//
//

import UIKit

extension UIColor {
  static func random() -> UIColor {
    let colors: [UIColor] = [.red, .blue, .green, .yellow, .purple, .orange]

    return colors[Int(arc4random()) % colors.count]
  }
}

struct Item { var color: UIColor }

class ItemCell : UICollectionViewCell { }

class SquaresViewController: UICollectionViewController {
  var items = [Item]()

  override func viewDidLoad() {
    super.viewDidLoad()

    collectionView?.backgroundColor = .white
    collectionView?.register(ItemCell.self, forCellWithReuseIdentifier: "ItemCell")
  }

  override func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
    return items.count
  }

  override func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
    let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "ItemCell", for: indexPath)

    cell.backgroundColor = items[indexPath.item].color

    return cell
  }
}

class SmallViewController : SquaresViewController {
  init() {
    let layout = UICollectionViewFlowLayout()
    
    layout.itemSize = CGSize(width: 50, height: 50)

    super.init(collectionViewLayout: layout)

    title = "Small Cells"
    useLayoutToLayoutNavigationTransitions = false

    items = (0...50).map { _ in Item(color: .random()) }
  }

  required init?(coder aDecoder: NSCoder) { fatalError() }

  override func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
    let bigVC = BigViewController()

    bigVC.items = items

    navigationController?.pushViewController(bigVC, animated: true)
  }
}

class BigViewController : SquaresViewController {
  init() {
    let layout = UICollectionViewFlowLayout()

    layout.itemSize = CGSize(width: 100, height: 100)

    super.init(collectionViewLayout: layout)

    title = "Big Cells"
    useLayoutToLayoutNavigationTransitions = true
  }

  required init?(coder aDecoder: NSCoder) { fatalError() }

  override func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
    navigationController?.popViewController(animated: true)
  }
}
